<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');
require_once 'db.php';
require_once __DIR__ . '/../vendor/autoload.php';

use Razorpay\Api\Api;

function getUpcomingEMIs($loanId) {
    global $conn;
    
    // Define Razorpay credentials
    $keyId = 'rzp_test_nng8R13YbhYV6f';
    $keySecret = 'M1BDCZDsKMNq7HRLBJboZtR7';
    
    try {
        // Get subscription_id and amount from database
        $stmt = $conn->prepare("
            SELECT s.subscription_id, s.emi_amount 
            FROM subscription_details s 
            WHERE s.loan_id = ?
        ");
        $stmt->bind_param("s", $loanId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            return [
                'status' => false,
                'message' => 'No subscription found for this loan ID',
                'data' => null
            ];
        }
        
        $subscription = $result->fetch_assoc();
        $subscriptionId = $subscription['subscription_id'];
        $emiAmount = isset($subscription['amount']) ? $subscription['amount'] : 0;
        
        // Initialize Razorpay API
        $api = new Api($keyId, $keySecret);
        
        // Fetch subscription details
        $razorpaySubscription = $api->subscription->fetch($subscriptionId);
        $planId = $razorpaySubscription->plan_id;
        
        // Fetch plan details to get the amount if not available in database
        if ($emiAmount == 0) {
            $plan = $api->plan->fetch($planId);
            $emiAmount = $plan->item->amount / 100; // Convert from paise to rupees
        }
        
        // Fetch all invoices
        $invoices = $api->invoice->all([
            'subscription_id' => $subscriptionId
        ]);
        
        // Process invoices and calculate future EMIs
        $emis = [];
        $currentTime = time();
        $startAt = $razorpaySubscription->start_at;
        $remainingCount = $razorpaySubscription->total_count - $razorpaySubscription->paid_count;
        
      // Add existing paid/pending invoices
foreach ($invoices->items as $invoice) {
    $invoiceData = $invoice->toArray();
    
    // Check if Razorpay provides a due date
    $dueDate = isset($invoiceData['due_at'])
               ? $invoiceData['due_at'] // Use due date if available
               : strtotime("+1 month", $startAt + (count($emis) * 30 * 24 * 60 * 60)); // Fallback for calculation
    
    // Get amount from invoice if available, otherwise use plan amount
    $amount = isset($invoiceData['amount']) ? $invoiceData['amount'] / 100 : $emiAmount;
    
    if ($dueDate >= $currentTime || $invoiceData['status'] === 'paid') {
        $emis[] = [
            'emi_id' => $invoiceData['id'],
            'amount' => $amount,
            'due_date' => date('Y-m-d', $dueDate),
            'status' => $invoiceData['status'],
            'payment_date' => isset($invoiceData['paid_at']) ? date('Y-m-d', $invoiceData['paid_at']) : null,
            'is_upcoming' => $dueDate > $currentTime,
            'invoice_number' => isset($invoiceData['invoice_number']) ? $invoiceData['invoice_number'] : null
        ];
    }
}
        // Calculate remaining future EMIs
        $lastPaidDate = $startAt;
        if (!empty($emis)) {
            $lastPaidDate = max(array_map(function($emi) {
                return strtotime($emi['due_date']);
            }, $emis));
        }
        
        // Add future EMIs
        for ($i = count($emis); $i < $razorpaySubscription->total_count; $i++) {
            $emiDate = $lastPaidDate + (($i - count($emis) + 1) * 30 * 24 * 60 * 60);
            
            if ($emiDate > $currentTime) {
                $emis[] = [
                    'emi_id' => 'future_' . ($i + 1),
                    'amount' => $emiAmount,
                    'due_date' => date('Y-m-d', $emiDate),
                    'status' => 'scheduled',
                    'payment_date' => null,
                    'is_upcoming' => true,
                    'invoice_number' => null
                ];
            }
        }
        
        // Sort EMIs by due date
        usort($emis, function($a, $b) {
            return strtotime($a['due_date']) - strtotime($b['due_date']);
        });
        
        $subscriptionDetails = [
            'status' => $razorpaySubscription->status,
            'start_at' => date('Y-m-d', $razorpaySubscription->start_at),
            'end_at' => date('Y-m-d', $razorpaySubscription->end_at),
            'total_count' => $razorpaySubscription->total_count,
            'paid_count' => $razorpaySubscription->paid_count,
            'remaining_count' => $remainingCount,
            'emi_amount' => $emiAmount
        ];
        
        return [
            'status' => true,
            'message' => 'Upcoming EMIs fetched successfully',
            'data' => [
                'emis' => $emis,
                'total_upcoming' => count($emis),
                'subscription_details' => $subscriptionDetails
            ]
        ];
        
    } catch (Exception $e) {
        return [
            'status' => false,
            'message' => 'Error: ' . $e->getMessage(),
            'data' => null
        ];
    }
}

// Handle the request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!isset($_GET['loan_id'])) {
        echo json_encode([
            'status' => false,
            'message' => 'Loan ID is required',
            'data' => null
        ]);
        exit;
    }
    
    $loanId = $_GET['loan_id'];
    $response = getUpcomingEMIs($loanId);
    echo json_encode($response);
    exit;
} else {
    echo json_encode([
        'status' => false,
        'message' => 'Invalid request method',
        'data' => null
    ]);
    exit;
}