<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

// Disable error display
error_reporting(0);
ini_set('display_errors', 0);

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require __DIR__ . '/../vendor/autoload.php';
include 'db.php';

use Razorpay\Api\Api;

class RazorpaySubscription {
    private $api;
    private $keyId;
    private $keySecret;
    
    public function __construct() {
        $this->keyId = 'rzp_test_nng8R13YbhYV6f'; // Replace with actual key
        $this->keySecret = 'M1BDCZDsKMNq7HRLBJboZtR7'; // Replace with actual secret
        $this->api = new Api($this->keyId, $this->keySecret);
    }
    
    public function createPlan($amount, $interval, $period) {
        try {
            $plan = $this->api->plan->create([
                'period' => $period,
                'interval' => $interval,
                'item' => [
                    'name' => 'EMI Payment Plan',
                    'amount' => $amount * 100,
                    'currency' => 'INR',
                    'description' => 'EMI Payment Plan for Product Purchase'
                ]
            ]);
            return $plan;
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
    
    public function createSubscription($planId, $customerId, $totalCount, $startDate) {
        try {
            $subscription = $this->api->subscription->create([
                'plan_id' => $planId,
                'customer_notify' => 1,
                'quantity' => 1,
                'total_count' => $totalCount,
                'start_at' => strtotime($startDate),
                'notes' => [
                    'customer_id' => $customerId
                ]
            ]);
            return $subscription;
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
    
    public function createCustomer($name, $email, $phone) {
        try {
            $customer = $this->api->customer->create([
                'name' => $name,
                'email' => $email,
                'contact' => $phone
            ]);
            return $customer;
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
    
    public function verifyWebhookSignature($webhookBody, $signature, $webhookSecret) {
        try {
            return $this->api->utility->verifyWebhookSignature(
                $webhookBody,
                $signature,
                $webhookSecret
            );
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
}

// API Endpoints
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        switch ($_GET['action']) {
            case 'create_subscription':
                $razorpay = new RazorpaySubscription();
                $data = json_decode(file_get_contents('php://input'), true);
                
                // Create customer
                $customer = $razorpay->createCustomer(
                    $data['customer_name'],
                    $data['customer_email'],
                    $data['customer_phone']
                );
                
                if (isset($customer['error'])) {
                    throw new Exception($customer['error']);
                }
                
                // Create plan with EMI amount
                $plan = $razorpay->createPlan(
                    $data['emi_amount'],
                    1,
                    'monthly'
                );
                
                if (isset($plan['error'])) {
                    throw new Exception($plan['error']);
                }
                
                // Create subscription
                $subscription = $razorpay->createSubscription(
                    $plan->id,
                    $customer->id,
                    $data['tenure'],
                    $data['start_date']
                );
                
                if (isset($subscription['error'])) {
                    throw new Exception($subscription['error']);
                }
                
                echo json_encode([
                    'subscription_id' => $subscription->id,
                    'customer_id' => $customer->id,
                    'plan_id' => $plan->id
                ]);
                break;
                
            case 'update_loan_subscription':
                $data = json_decode(file_get_contents('php://input'), true);
                
                // Validate required fields
                $required_fields = ['loan_id', 'subscription_id', 'first_payment_date', 'emi_amount', 'tenure'];
                foreach ($required_fields as $field) {
                    if (!isset($data[$field]) || empty($data[$field])) {
                        throw new Exception("Missing required field: {$field}");
                    }
                }
                
                // Start transaction
                $conn->begin_transaction();
                
                // // Create subscription_details table if not exists
                // $createTableSQL = "CREATE TABLE IF NOT EXISTS subscription_details (
                //     id INT PRIMARY KEY AUTO_INCREMENT,
                //     loan_id VARCHAR(25),
                //     subscription_id VARCHAR(100),
                //     first_payment_date DATE,
                //     emi_amount DECIMAL(12,2),
                //     tenure INT,
                //     subscription_status ENUM('initiated', 'active', 'completed', 'cancelled') DEFAULT 'initiated',
                //     created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                //     updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                //     FOREIGN KEY (loan_id) REFERENCES loan_applications(loan_id)
                // )";
                
                // if (!$conn->query($createTableSQL)) {
                //     throw new Exception("Failed to create table: " . $conn->error);
                // }
                
                // Check for existing subscription
                $checkSQL = "SELECT id FROM subscription_details WHERE loan_id = ? OR subscription_id = ?";
                $stmt = $conn->prepare($checkSQL);
                $stmt->bind_param("ss", $data['loan_id'], $data['subscription_id']);
                $stmt->execute();
                if ($stmt->get_result()->num_rows > 0) {
                    throw new Exception("Subscription already exists for this loan");
                }
                
                // Insert subscription details
                $insertSQL = "INSERT INTO subscription_details 
                    (loan_id, subscription_id, first_payment_date, emi_amount, tenure) 
                    VALUES (?, ?, ?, ?, ?)";
                    
                $stmt = $conn->prepare($insertSQL);
                $stmt->bind_param(
                    "sssdi",
                    $data['loan_id'],
                    $data['subscription_id'],
                    $data['first_payment_date'],
                    $data['emi_amount'],
                    $data['tenure']
                );
                $stmt->execute();
                
                // Update loan status
                $updateSQL = "UPDATE loan_applications 
                    SET application_status = 'subscription_initiated' 
                    WHERE loan_id = ?";
                    
                $stmt = $conn->prepare($updateSQL);
                $stmt->bind_param("s", $data['loan_id']);
                $stmt->execute();
                
                $conn->commit();
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Subscription details saved successfully'
                ]);
                break;
                
            case 'webhook':
                $webhookSecret = "YOUR_WEBHOOK_SECRET";
                $webhookBody = file_get_contents('php://input');
                $signature = $_SERVER['HTTP_X_RAZORPAY_SIGNATURE'];
                
                // Create instance of RazorpaySubscription
                $razorpay = new RazorpaySubscription();
                
                // Verify webhook signature
                $verificationResult = $razorpay->verifyWebhookSignature($webhookBody, $signature, $webhookSecret);
                if (isset($verificationResult['error'])) {
                    throw new Exception($verificationResult['error']);
                }
                
                $data = json_decode($webhookBody, true);
                
                // Handle webhook events
                switch ($data['event']) {
                    case 'subscription.activated':
                        // Update subscription status to active
                        $sql = "UPDATE subscription_details SET subscription_status = 'active' 
                               WHERE subscription_id = ?";
                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("s", $data['payload']['subscription']['id']);
                        $stmt->execute();
                        break;
                        
                    case 'subscription.charged':
                        // Log payment received
                        break;
                        
                    case 'subscription.completed':
                        // Update subscription status to completed
                        $sql = "UPDATE subscription_details SET subscription_status = 'completed' 
                               WHERE subscription_id = ?";
                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("s", $data['payload']['subscription']['id']);
                        $stmt->execute();
                        break;
                        
                    case 'subscription.cancelled':
                        // Update subscription status to cancelled
                        $sql = "UPDATE subscription_details SET subscription_status = 'cancelled' 
                               WHERE subscription_id = ?";
                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("s", $data['payload']['subscription']['id']);
                        $stmt->execute();
                        break;
                }
                
                echo json_encode(['status' => 'success']);
                break;
                
            default:
                throw new Exception('Invalid action specified');
        }
    } catch (Exception $e) {
        // Rollback if transaction is active
        if (isset($conn) && !$conn->connect_error) {
            $conn->rollback();
        }
        
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'error' => $e->getMessage()
        ]);
    }
}