<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

require __DIR__ . '/../vendor/autoload.php';

use Razorpay\Api\Api;

try {
    // Validate input
    if (!isset($_GET['subscription_id'])) {
        throw new Exception('Subscription ID is required');
    }

    $subscriptionId = $_GET['subscription_id'];

    // Initialize Razorpay API
    $api = new Api("rzp_test_nng8R13YbhYV6f", "M1BDCZDsKMNq7HRLBJboZtR7");

    // Fetch all invoices for the subscription
    $invoicesCollection = $api->invoice->all([
        'subscription_id' => $subscriptionId,
        'count' => 100 // Adjust based on your needs
    ]);

    // Convert Collection to array
    $invoices = $invoicesCollection->toArray()['items'];

    // Process and format the invoice data
    $formattedInvoices = array_map(function($invoice) {
        return [
            'id' => $invoice['id'] ?? null,
            'invoice_number' => $invoice['invoice_number'] ?? null,
            'subscription_id' => $invoice['subscription_id'] ?? null,
            'status' => $invoice['status'] ?? null,
            'date' => $invoice['date'] ?? null,
            'paid_at' => $invoice['paid_at'] ?? null,
            'amount' => $invoice['amount'] ?? null,
            'currency' => $invoice['currency'] ?? null,
            'description' => $invoice['description'] ?? null,
            'invoice_url' => $invoice['short_url'] ?? null,
            'download_url' => $invoice['invoice_url'] ?? null,
            'payment_id' => $invoice['payment_id'] ?? null
        ];
    }, $invoices);

    // Add debug information
    error_log("Raw Invoice Data: " . print_r($invoices, true));
    error_log("Formatted Invoice Data: " . print_r($formattedInvoices, true));

    echo json_encode([
        'success' => true,
        'items' => $formattedInvoices
    ]);

} catch (Exception $e) {
    http_response_code(500);
    error_log("Error: " . $e->getMessage());
    error_log("Stack trace: " . $e->getTraceAsString());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>