<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');
require_once 'db.php';
require_once __DIR__ . '/../vendor/autoload.php';

use Razorpay\Api\Api;

function getSubscriptionDetails($loanId) {
    global $conn;
    
    // Define Razorpay credentials inside the function
    $keyId = 'rzp_test_nng8R13YbhYV6f';          // Replace with your test/live key
    $keySecret = 'M1BDCZDsKMNq7HRLBJboZtR7';    // Replace with your test/live secret
    
    try {
        // Fetch subscription_id from database based on loan_id
        $stmt = $conn->prepare("SELECT subscription_id FROM subscription_details WHERE loan_id = ?");
        $stmt->bind_param("s", $loanId);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            return [
                'status' => false,
                'message' => 'No subscription found for this loan ID',
                'data' => null
            ];
        }
        
        $subscription = $result->fetch_assoc();
        $subscriptionId = $subscription['subscription_id'];
        
        // Initialize Razorpay API
        $api = new Api($keyId, $keySecret);
        
        // Fetch subscription details from Razorpay
        $razorpaySubscription = $api->subscription->fetch($subscriptionId);
        
        // Fetch invoices for this subscription
        $invoices = $api->invoice->all([
            'subscription_id' => $subscriptionId
        ]);
        
        return [
            'status' => true,
            'message' => 'Subscription details fetched successfully',
            'data' => [
                'subscription' => $razorpaySubscription->toArray(),
                'invoices' => $invoices->toArray()
            ]
        ];
        
    } catch (Exception $e) {
        return [
            'status' => false,
            'message' => 'Error: ' . $e->getMessage(),
            'data' => null
        ];
    }
}

// Handle the request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!isset($_GET['loan_id'])) {
        echo json_encode([
            'status' => false,
            'message' => 'Loan ID is required',
            'data' => null
        ]);
        exit;
    }
    
    $loanId = $_GET['loan_id'];
    $response = getSubscriptionDetails($loanId);
    echo json_encode($response);
    exit;
} else {
    echo json_encode([
        'status' => false,
        'message' => 'Invalid request method',
        'data' => null
    ]);
    exit;
}