<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

require __DIR__ . '/../vendor/autoload.php';
use Razorpay\Api\Api;

class SubscriptionService {
    private $api;
    private $keyId;
    private $keySecret;

    public function __construct() {
        // Replace with actual key and secret, preferably stored in environment variables
        $this->keyId = 'rzp_test_nng8R13YbhYV6f';
        $this->keySecret = 'M1BDCZDsKMNq7HRLBJboZtR7';
        $this->api = new Api($this->keyId, $this->keySecret);
    }

    private function safeGet($obj, $prop, $default = null) {
        if (is_object($obj)) {
            return property_exists($obj, $prop) ? $obj->$prop : $default;
        }
        return $default;
    }

    public function getUpcomingInvoices($subscriptionId) {
        try {
            $subscription = $this->api->subscription->fetch($subscriptionId);
            $plan = $this->api->plan->fetch($subscription->plan_id);
            
            if ($this->safeGet($subscription, 'status') !== 'active') {
                return ['subscription_status' => $this->safeGet($subscription, 'status'), 'upcoming_invoices' => []];
            }

            $upcomingInvoices = [];
            $startTime = max(time(), $this->safeGet($subscription, 'start_at', time()));
            $remainingCount = $this->safeGet($subscription, 'remaining_count', 0);
            $periodUnit = $this->safeGet($plan, 'period_unit', 'month');

            for ($i = 0; $i < $remainingCount; $i++) {
                $nextDate = strtotime("+{$i} {$periodUnit}", $startTime);
                $upcomingInvoices[] = [
                    'invoice_number' => sprintf('UPCOMING_%d', $i + 1),
                    'due_date' => date('Y-m-d H:i:s', $nextDate),
                    'amount' => $this->safeGet($plan, 'amount', 0) / 100,
                    'currency' => $this->safeGet($plan, 'currency', 'INR'),
                    'status' => 'upcoming'
                ];
            }

            return [
                'subscription_status' => $this->safeGet($subscription, 'status'),
                'plan_details' => [
                    'name' => $this->safeGet($plan->item, 'name', 'Unknown Plan'),
                    'description' => $this->safeGet($plan->item, 'description', 'No Description'),
                    'period' => $this->safeGet($plan, 'period', 'monthly'),
                    'period_unit' => $periodUnit
                ],
                'upcoming_invoices' => $upcomingInvoices
            ];
        } catch (Exception $e) {
            throw new Exception("Failed to fetch upcoming invoices: " . $e->getMessage());
        }
    }

    public function getPaymentHistory($subscriptionId) {
        try {
            $pastInvoices = $this->api->invoice->all(['subscription_id' => $subscriptionId, 'count' => 100]);

            $paymentHistory = [];
            foreach ($pastInvoices->items as $invoice) {
                $paymentHistory[] = [
                    'invoice_id' => $this->safeGet($invoice, 'id', 'N/A'),
                    'invoice_number' => $this->safeGet($invoice, 'invoice_number', 'N/A'),
                    'payment_id' => $this->safeGet($invoice, 'payment_id', 'N/A'),
                    'status' => $this->safeGet($invoice, 'status', 'unknown'),
                    'amount' => $this->safeGet($invoice, 'amount', 0) / 100,
                    'currency' => $this->safeGet($invoice, 'currency', 'INR'),
                    'date' => $this->safeGet($invoice, 'date') ? date('Y-m-d H:i:s', $invoice->date) : null,
                    'paid_at' => $this->safeGet($invoice, 'paid_at') ? date('Y-m-d H:i:s', $invoice->paid_at) : null,
                    'invoice_url' => $this->safeGet($invoice, 'short_url'),
                    'download_url' => $this->safeGet($invoice, 'invoice_url')
                ];
            }

            return ['payment_history' => $paymentHistory];
        } catch (Exception $e) {
            throw new Exception("Failed to fetch payment history: " . $e->getMessage());
        }
    }

    public function getSubscriptionDetails($subscriptionId) {
        try {
            $subscription = $this->api->subscription->fetch($subscriptionId);
            $plan = $this->api->plan->fetch($subscription->plan_id);
            $upcomingInvoices = $this->getUpcomingInvoices($subscriptionId);
            $paymentHistory = $this->getPaymentHistory($subscriptionId);

            return [
                'success' => true,
                'subscription_details' => [
                    'id' => $this->safeGet($subscription, 'id', 'N/A'),
                    'status' => $this->safeGet($subscription, 'status', 'unknown'),
                    'created_at' => $this->safeGet($subscription, 'created_at') ? 
                        date('Y-m-d H:i:s', $subscription->created_at) : null,
                    'start_at' => $this->safeGet($subscription, 'start_at') ? 
                        date('Y-m-d H:i:s', $subscription->start_at) : null,
                    'end_at' => $this->safeGet($subscription, 'end_at') ? 
                        date('Y-m-d H:i:s', $subscription->end_at) : null,
                    'quantity' => $this->safeGet($subscription, 'quantity', 1),
                    'remaining_count' => $this->safeGet($subscription, 'remaining_count', 0),
                    'paid_count' => $this->safeGet($subscription, 'paid_count', 0),
                    'total_count' => $this->safeGet($subscription, 'total_count', 0),
                    'customer_notify' => $this->safeGet($subscription, 'customer_notify', false)
                ],
                'plan_details' => [
                    'id' => $this->safeGet($plan, 'id', 'N/A'),
                    'name' => $this->safeGet($plan->item, 'name', 'Unknown Plan'),
                    'description' => $this->safeGet($plan->item, 'description', 'No Description'),
                    'amount' => $this->safeGet($plan, 'amount', 0) / 100,
                    'currency' => $this->safeGet($plan, 'currency', 'INR'),
                    'period' => $this->safeGet($plan, 'period', 'monthly'),
                    'period_unit' => $this->safeGet($plan, 'period_unit', 'month')
                ],
                'upcoming_invoices' => $upcomingInvoices['upcoming_invoices'],
                'payment_history' => $paymentHistory['payment_history']
            ];
        } catch (Exception $e) {
            throw new Exception("Failed to fetch subscription details: " . $e->getMessage());
        }
    }
}

// Error reporting configuration
ini_set('display_errors', 0);
error_reporting(E_ALL);

// API Endpoint
try {
    if (!isset($_GET['subscription_id'])) {
        throw new Exception('Subscription ID is required');
    }

    $subscriptionId = $_GET['subscription_id'];
    $subscriptionService = new SubscriptionService();
    
    $result = $subscriptionService->getSubscriptionDetails($subscriptionId);
    echo json_encode($result);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>