<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');
// include 'db.php';

// require 'vendor/autoload.php';
require __DIR__ . '/../vendor/autoload.php';

use Razorpay\Api\Api;

class RazorpaySubscription {
    private $api;
    private $keyId;
    private $keySecret;
    
    public function __construct() {
        $this->keyId = 'rzp_test_nng8R13YbhYV6f'; // Replace with actual key
        $this->keySecret = 'M1BDCZDsKMNq7HRLBJboZtR7'; // Replace with actual secret
        $this->api = new Api($this->keyId, $this->keySecret);
    }
    
    public function createPlan($amount, $interval, $period) {
        try {
            $plan = $this->api->plan->create([
                'period' => $period, // 'weekly', 'monthly', 'yearly'
                'interval' => $interval, // number of periods
                'item' => [
                    'name' => 'EMI Payment Plan',
                    'amount' => $amount * 100, // amount in smallest currency unit (paise)
                    'currency' => 'INR',
                    'description' => 'EMI Payment Plan for Product Purchase'
                ]
            ]);
            return $plan;
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
    
    public function createSubscription($planId, $customerId, $totalCount) {
        try {
            $subscription = $this->api->subscription->create([
                'plan_id' => $planId,
                'customer_notify' => 1,
                'quantity' => 1,
                'total_count' => $totalCount,
                'notes' => [
                    'customer_id' => $customerId
                ]
            ]);
            return $subscription;
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
    
    public function createCustomer($name, $email, $phone) {
        try {
            $customer = $this->api->customer->create([
                'name' => $name,
                'email' => $email,
                'contact' => $phone
            ]);
            return $customer;
        } catch (Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }
}

// API Endpoints
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $razorpay = new RazorpaySubscription();
    
    switch ($_GET['action']) {
        case 'create_subscription':
            $data = json_decode(file_get_contents('php://input'), true);
            
            // Create customer
            $customer = $razorpay->createCustomer(
                $data['customer_name'],
                $data['customer_email'],
                $data['customer_phone']
            );
            
            if (isset($customer['error'])) {
                echo json_encode(['error' => $customer['error']]);
                exit;
            }
            
            // Create plan
            $plan = $razorpay->createPlan(
                $data['emi_amount'],
                1, // 1 interval
                'monthly' // period type
            );
            
            if (isset($plan['error'])) {
                echo json_encode(['error' => $plan['error']]);
                exit;
            }
            
            // Create subscription
            $subscription = $razorpay->createSubscription(
                $plan->id,
                $customer->id,
                $data['tenure'] // number of months
            );
            
            if (isset($subscription['error'])) {
                echo json_encode(['error' => $subscription['error']]);
                exit;
            }
            
            echo json_encode([
                'subscription_id' => $subscription->id,
                'short_url' => $subscription->short_url
            ]);
            break;
            
        case 'webhook':
            $webhookSecret = "YOUR_WEBHOOK_SECRET";
            $webhookBody = file_get_contents('php://input');
            $signature = $_SERVER['HTTP_X_RAZORPAY_SIGNATURE'];
            
            try {
                $this->api->utility->verifyWebhookSignature(
                    $webhookBody,
                    $signature,
                    $webhookSecret
                );
                
                $data = json_decode($webhookBody, true);
                
                // Handle different webhook events
                switch ($data['event']) {
                    case 'subscription.activated':
                        // Update your database - subscription started
                        break;
                    case 'subscription.charged':
                        // Update your database - EMI payment received
                        break;
                    case 'subscription.completed':
                        // Update your database - all EMIs completed
                        break;
                    case 'subscription.cancelled':
                        // Update your database - subscription cancelled
                        break;
                }
                
                echo json_encode(['status' => 'success']);
            } catch (Exception $e) {
                echo json_encode(['error' => $e->getMessage()]);
            }
            break;
    }
}